package gov.va.med.mhv.usermgmt.web.controller;

import java.io.IOException;
import java.util.List;

import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpSession;

import org.springframework.stereotype.Component;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;

import gov.va.med.mhv.common.api.dto.UserProfileDTO;

@ManagedBean
@Component

public class PersonalInformationController  extends AbstractController{
	private static final long serialVersionUID = 5050128896390892884L;
	private boolean showVBHB=false;
	private Long userProfileId;
	private UserProfileDTO userProfileDTO = null;
	private String liferayUserId = "";
	
	public void authorize(ComponentSystemEvent event) throws IOException, PortalException, SystemException{
		
		PortletRequest   request = (PortletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
		PortletSession session = request.getPortletSession();
		FacesContext context =FacesContext.getCurrentInstance();
		if(request.getUserPrincipal() == null){
			context.getApplication().getNavigationHandler().handleNavigation(context, null, "uanuthorized.xhtml");
		}
		System.out.println("*****PersonalInformationController Authorize");
		User liferayUser = PortalUtil.getUser(request);
		System.out.println("*****PersonalInformationController Authorize found liferayUser: " + liferayUser.getFullName());
		Object profileId = session.getAttribute("LIFERAY_SHARED_userprofileid", PortletSession.APPLICATION_SCOPE);
		if(profileId != null){
			userProfileId = (Long)profileId;
			userProfileDTO = getUserProfile(userProfileId);
			liferayUserId = userProfileDTO.getUserName();
			setShowVBHB(false);
			System.out.println("*****PersonalInformationController Authorize got userProfile userName: " + userProfileDTO.getUserName());
			List<Role> liferayUserRoles = liferayUser.getRoles();
			System.out.println("*****PersonalInformationController Authorize getting roles object");
			for(Role role : liferayUserRoles) {
				System.out.println("*****PersonalInformationController role: " + role.getName());
				if(role.getName().equals("MHV_DSLOGON")) {
					System.out.println("*****PersonalInformationController found MHV_DSLOGON role from Role");
					setShowVBHB(true);
				}
			}
		}
	}
	
	public boolean getShowVBHB() {
		return showVBHB;
	}

	public void setShowVBHB(boolean showVBHB) {
		this.showVBHB = showVBHB;
	}
	
//	private <T> T getSafeSessionAttribute(ObjectMapper mapper, PortletSession portletSession, String attributeName, Class<UserProfileDTO> class1) throws ActionException {
//        if(portletSession!=null) {
//        	System.out.println("*****PersonalInformationController portlet session.getId(): "+portletSession.getId());
//        }
//		try {
//			Object sessionAttribute = portletSession.getAttribute(attributeName);
//			if(sessionAttribute != null && sessionAttribute instanceof String) {
//               return (T) mapper.readValue((String)sessionAttribute, class1);
//			}
//			return (T)sessionAttribute;
//		} catch (Exception e) {
//			throw new ActionException(String.format("Error getting session attribute '%s' from session.", attributeName), e);
//		}
//	}
}
